---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：10-Markdown Document Renderer

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **目標レンダリング時間**：明示的な定義なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/markdown/browser/markdownDocumentRenderer.ts` - renderMarkdownDocument() (行223-253)
- E-02: `src/vs/workbench/contrib/markdown/browser/markdownDocumentRenderer.ts` - DEFAULT_MARKDOWN_STYLES (行18-158)
- E-03: `src/vs/workbench/contrib/markdown/browser/markdownDocumentRenderer.ts` - sanitize() (行165-190)
- E-04: `src/vs/workbench/contrib/markdown/browser/markdownDocumentRenderer.ts` - MarkdownDocumentSanitizerConfig (行192-210)
- E-05: `src/vs/workbench/contrib/markdown/browser/markdownDocumentRenderer.ts` - defaultAllowedLinkProtocols (行160-163)
- E-06: `src/vs/workbench/contrib/markdown/browser/markdownDocumentRenderer.ts` - MarkedHighlight (行255-333)
- E-07: `src/vs/workbench/contrib/markdown/browser/markdownDocumentRenderer.ts` - highlight関数 (行233-244)
- E-08: `src/vs/workbench/contrib/markdown/browser/markdownDocumentRenderer.ts` - languageId取得 (行243)
- E-09: `src/vs/workbench/contrib/markdown/browser/markdownDocumentRenderer.ts` - tokenizeToString (行244)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 出力はTrustedHTML型 | E-01 (行229) | ○ |
| C-02 | デフォルトスタイルにbody設定 | E-02 (行19-24) | ○ |
| C-03 | コードフォントにSF Mono等 | E-02 (行95-96) | ○ |
| C-04 | pre codeにVS Codeフォント変数 | E-02 (行104-111) | ○ |
| C-05 | vscode-light用スタイル | E-02 (行127-139) | ○ |
| C-06 | vscode-dark用スタイル | E-02 (行131-145) | ○ |
| C-07 | vscode-high-contrast用スタイル | E-02 (行123-125) | ○ |
| C-08 | デフォルト許可プロトコルはhttp, https | E-05 | ○ |
| C-09 | sanitizeでsanitizeHtml呼び出し | E-03 (行166) | ○ |
| C-10 | allowedLinkProtocolsのoverride | E-03 (行167-169) | ○ |
| C-11 | allowedTagsのoverride/augment | E-03 (行173-176) | ○ |
| C-12 | allowedAttributesのoverride/augment | E-03 (行177-188) | ○ |
| C-13 | 追加許可属性にname, id, class等 | E-03 (行179-185) | ○ |
| C-14 | marked.jsを使用 | E-01 (行230) | ○ |
| C-15 | MarkedHighlightでコードハイライト | E-06, E-01 (行231-246) | ○ |
| C-16 | async: trueで非同期highlight | E-07 (行232) | ○ |
| C-17 | whenInstalledExtensionsRegistered待機 | E-07 (行238) | ○ |
| C-18 | キャンセル時に空文字返却 | E-07 (行239-241) | ○ |
| C-19 | getLanguageIdByLanguageName使用 | E-08 | ○ |
| C-20 | 言語名先頭部分で再試行 | E-08 (split処理) | ○ |
| C-21 | tokenizeToStringでトークン化 | E-09 | ○ |
| C-22 | markedGfmHeadingIdPlugin使用 | E-01 (行247) | ○ |
| C-23 | raceCancellationError使用 | E-01 (行251) | ○ |
| C-24 | 目標レンダリング時間500ms | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（目標レンダリング時間）は実装コードに明示的な定義がない
  - 候補：パフォーマンステスト仕様書 / 非機能要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - デフォルトスタイル定義（E-02に基づく）
- 0: 低リスク - サニタイズ設定（E-03, E-04, E-05に基づく）
- 0: 低リスク - コードハイライト処理（E-06, E-07に基づく）
- 1: 中リスク - パフォーマンス要件（推測に基づく記述）

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトスタイル（DEFAULT_MARKDOWN_STYLES）が正しいか
- [ ] 許可プロトコル（http, https）が正しいか
- [ ] 許可属性（name, id, class, role, tabindex, placeholder）が完全か
- [ ] コードハイライト処理（highlight関数）が正しいか
- [ ] キャンセル処理が正しく実装されているか
